/* 
 * File:   define.h
 * Author: Wilhelm Leichtfried - C15279
 *
 * Created on June 30, 2015, 3:47 PM
 */
/*******************************************************************************
Copyright (c) 2014 released Microchip Technology Inc.  All rights reserved.

Microchip licenses to you the right to use, modify, copy and distribute
Software only when embedded on a Microchip microcontroller or digital signal
controller that is integrated into your product or third party product
(pursuant to the sublicense terms in the accompanying license agreement).

You should refer to the license agreement accompanying this Software for
additional information regarding your rights and obligations.

SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
(INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.
*******************************************************************************/

#ifndef DEFINE_H
#define	DEFINE_H

// General
#define TRUE                1
#define FALSE               0
#define ON                  1
#define OFF                 0
#define OUTPUT              0
#define INPUT               1

// LEDs (D3-D10/RA0-RA7) drive state low
#define LED3_PIN            TRISAbits.TRISA0                           // LED for debuging purposes
#define LED3                LATAbits.LATA0                             // LED for debuging purposes
#define LED4_PIN            TRISAbits.TRISA1                           // LED for debuging purposes
#define LED4                LATAbits.LATA1                             // LED for debuging purposes
#define LED5_PIN            TRISAbits.TRISA2                           // LED for debuging purposes
#define LED5                LATAbits.LATA2                             // LED for debuging purposes
#define LED6_PIN            TRISAbits.TRISA3                           // LED for debuging purposes
#define LED6                LATAbits.LATA3                             // LED for debuging purposes
#define LED7_PIN            TRISAbits.TRISA4                           // LED for debuging purposes
#define LED7                LATAbits.LATA4                             // LED for debuging purposes
#define LED8_PIN            TRISAbits.TRISA5                           // LED for debuging purposes
#define LED8                LATAbits.LATA5                             // LED for debuging purposes
#define LED9_PIN            TRISAbits.TRISA6                           // LED for debuging purposes
#define LED9                LATAbits.LATA6                             // LED for debuging purposes
#define LED10_PIN           TRISAbits.TRISA7                           // LED for debuging purposes
#define LED10               LATAbits.LATA7                             // LED for debuging purposes

// Buttons
#define S3_PIN              TRISDbits.TRISD6
#define S3                  PORTDbits.RD6
#define S4_PIN              TRISDbits.TRISD13
#define S4                  PORTDbits.RD13
#define S5_PIN              TRISAbits.TRISA7
#define S5                  PORTAbits.RA7
#define S6_PIN              TRISDbits.TRISD7
#define S6                  PORTDbits.RD7

// CAN PINs
#define CAN_CS_PIN          TRISBbits.TRISB5
#define CAN_CS              LATBbits.LATB5
#define CAN_SCK_PIN         TRISFbits.TRISF6
#define CAN_SCK             LATFbits.LATF6
#define CAN_MOSI_PIN        TRISFbits.TRISF8                            // Micro side
#define CAN_MOSI            LATFbits.LATF8
#define CAN_MISO_PIN        TRISFbits.TRISF7                            // Micro side
#define CAN_MISO            LATFbits.LATF7

#define CAN_STBY_PIN        TRISBbits.TRISB6
#define CAN_STBY            LATBbits.LATB6

#define CAN_INTERRUPT_PIN   TRISAbits.TRISA12
#define CAN_INTERRUPT       LATAbits.LATA12


#define CAN_CS_LOW()       CAN_CS = 0;
#define CAN_CS_HIGH()      CAN_CS = 1;

#endif	/* DEFINE_H */

